<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$firstName = $data['contact']['firstName'] ?? '';
$lastName = $data['contact']['lastName'] ?? '';
$email = $data['contact']['email'] ?? '';
$mobile = $data['contact']['mobile'] ?? '';

$from = $data['from'] == ''  ? 'Victoria' : $data['name'];
$to =  $data['from'] == ''  ? 'QueenLand' : $data['name'];

$date = $data['moving_time']['date'] ?? '';
$option = $data['moving_time']['option'] ?? '';
$contactTime = $data['contactTime'] ?? '';
$enquiry = $data['enquiry'] ?? '';

$propertyType = $data['properites']['properties']['property_type'] ?? '';
$subDetail = $data['properites']['properties']['sub_detail'] ?? '';
$otherReason = $data['properites']['properties']['other_reason'] ?? '';

$addons = $data['addons'] ?? [];
$packing = !empty($addons['packing']) ? 'Yes' : 'No';
$insurance = !empty($addons['insurance']) ? 'Yes' : 'No';
$storage = !empty($addons['storage']) ? 'Yes' : 'No';

$previousBooking = $data['previousBooking'] ?? '';

// Format the date (if it's a stringified date object)
$formattedDate = '';
if (!empty($date)) {
    try {
        $dt = new DateTime($date);
        $formattedDate = $dt->format('F j, Y');
    } catch (Exception $e) {
        $formattedDate = $date;
    }
}

$message = <<<HTML
<h2>New Quote Submitted</h2>

<p><strong>Name:</strong> {$firstName} {$lastName}</p>
<p><strong>Email:</strong> {$email}</p>
<p><strong>Mobile:</strong> {$mobile}</p>

<p><strong>Moving From:</strong> {$from}</p>
<p><strong>Moving To:</strong> {$to}</p>

<p><strong>Property Type:</strong> {$propertyType} - {$subDetail}</p>
<p><strong>Moving Date:</strong> {$date} {$option}</p>
<p><strong>Enquiry:</strong> {$enquiry}</p>
<p><strong>Quote Type:</strong> Unsure</p>

<p><strong>Previous Booking:</strong> {$previousBooking}</p>
<p><strong>Contact Time:</strong> {$contactTime}</p>

<p><strong>Addons:</strong><br>
- Packing: {$packing}<br>
- Insurance: {$insurance}<br>
- Storage: {$storage}
</p>

<p><strong>Other Notes:</strong> {$otherReason}</p>
HTML;

// Now you can send this $message via mail()

$toEmail = 'darwin.central.movers@gmail.com';
$subject = 'New Moving Enquiry';
$headers = "From: info@darwincentralmovers.com.au\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html;charset=UTF-8\r\n";
$headers .= "Reply-To: manojrawat87634@gmail.com\r\n";

if (mail($toEmail, $subject, $message, $headers)) {
    echo json_encode(['success' => true]);
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Mail failed']);
}
