 function initAutocomplete() {
      const inputs = document.querySelectorAll(".autocomplete"); // target all inputs with class="autocomplete"
      const options = {
        componentRestrictions: {
          country: "AU"
        },
        types: ["geocode"],
      };
      inputs.forEach(input => {
        const autocompleteInstance = new google.maps.places.Autocomplete(input, options);
        autocompleteInstance.addListener("place_changed", function () {
          formatAndSetPlace(autocompleteInstance, input);
        });
      });

      function formatAndSetPlace(autocompleteInstance, inputElement) {
        const place = autocompleteInstance.getPlace();

        let postcode = "";
        let city = "";

        if (place.address_components) {
          console.log(place.address_components);

          place.address_components.forEach(component => {
            if (component.types.includes("postal_code")) {
              postcode = component.long_name;
            }
            if (
              component.types.includes("locality") ||
              component.types.includes("administrative_area_level_1")
            ) {
              city = component.long_name.toUpperCase();
            }
          });

          if (postcode && city) {
            inputElement.value = `${postcode} ${city}`;
          } else {
            inputElement.value = place.formatted_address;
          }
        }
      }
    }

    window.onload = initAutocomplete;