
const services =  [
  {
    title: "Full-Service Guest Room Furniture Removal",
       icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M2 7.25C1.58579 7.25 1.25 7.58579 1.25 8V13.4872V13.4872C1.24998 15.4578 1.24997 17.0159 1.41991 18.2347C1.59493 19.4901 1.96296 20.4957 2.78115 21.2846C3.59552 22.0699 4.6271 22.4198 5.9157 22.5869C7.17418 22.75 8.78537 22.75 10.8338 22.75H13.1662C15.2146 22.75 16.8258 22.75 18.0843 22.5869C19.3729 22.4198 20.4045 22.0699 21.2189 21.2846C22.037 20.4957 22.4051 19.4901 22.5801 18.2347C22.75 17.0159 22.75 15.4578 22.75 13.4872V8C22.75 7.58579 22.4142 7.25 22 7.25H2Z\" fill=\"currentColor\" opacity=\"0.4\"></path><path d=\"M22.5748 18.2718C22.3979 17.8949 22.1022 17.3629 21.6325 16.7655C20.8228 15.7353 19.6799 15.045 16.168 15.045L16.168 13.8388C16.1689 13.3485 16.0395 12.8551 15.5635 12.6138C14.9217 12.2885 14.4274 12.7005 13.9652 13.0858C13.9399 13.1069 13.9148 13.1278 13.8897 13.1486C13.8297 13.1982 13.7694 13.2479 13.7089 13.2977C13.1272 13.7766 12.5279 14.27 12.0859 14.8816C11.9185 15.1132 11.668 15.5142 11.668 15.9993C11.668 16.4845 11.9185 16.8854 12.0859 17.1171C12.5279 17.7286 13.1272 18.222 13.7089 18.701C13.7694 18.7508 13.8297 18.8004 13.8897 18.85C13.9079 18.8651 13.9262 18.8803 13.9445 18.8956C14.4107 19.2829 14.9238 19.7092 15.5635 19.3848C16.0504 19.138 16.1686 18.6353 16.168 18.1376V17.0451C19.468 17.0451 20.9022 18.5136 20.6313 20.2289C20.4755 21.2157 19.7194 22.0229 18.8041 22.4667C19.7642 22.2673 20.5621 21.9172 21.2189 21.2839C22.0288 20.5029 22.3976 19.5095 22.5748 18.2718Z\" fill=\"currentColor\"></path><path d=\"M8.52755 1.25H15.4724C16.3755 1.24998 17.1309 1.24996 17.75 1.31454C18.4047 1.38284 18.9966 1.53023 19.5432 1.87979C20.0898 2.22936 20.4593 2.69681 20.7768 3.2503C21.0771 3.77368 21.3676 4.44256 21.7149 5.24222L22.6746 7.45172C22.7397 7.60176 22.7612 7.75879 22.7446 7.9098C22.7001 7.53812 22.3837 7.25 22 7.25H20.4696L19.9308 6.00946C19.5582 5.15173 19.3075 4.57789 19.0645 4.1543C18.833 3.75079 18.651 3.56262 18.459 3.43984C18.2671 3.31706 18.016 3.22828 17.5387 3.17849C17.0376 3.12622 16.389 3.12494 15.4204 3.12494H13V7.25H11V3.12494H8.57963C7.61098 3.12494 6.96239 3.12622 6.46133 3.17849C5.98402 3.22828 5.73295 3.31706 5.54097 3.43984C5.34898 3.56262 5.16699 3.75079 4.9355 4.1543C4.69249 4.57789 4.4418 5.15173 4.06924 6.00946L3.53042 7.25H2C1.61632 7.25 1.29992 7.53811 1.25537 7.90979C1.23877 7.75879 1.26026 7.60176 1.32543 7.45172L2.28512 5.24223C2.63242 4.44256 2.92293 3.77368 3.22319 3.2503C3.54072 2.69681 3.91021 2.22936 4.45681 1.87979C5.0034 1.53023 5.59532 1.38284 6.25004 1.31454C6.86913 1.24996 7.62453 1.24998 8.52755 1.25Z\" fill=\"currentColor\"></path></svg>",
    image: "images/PCM Service 1.webp",
    description:
      "We manage room relocations including dismantling, padding, and transporting beds, wardrobes, desks, and TVs with zero damage."
  },
  {
    title: "Lobby, Lounge, and Function Area Relocations",
       icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16.0173 2.32514C16.5421 2.40348 17.1135 2.59299 17.4411 3.16038C17.7678 3.72637 17.6484 4.31617 17.4563 4.81136C17.2715 5.2879 16.9438 5.86433 16.5621 6.53565L15.4611 8.47252C15.2529 8.8388 15.1188 9.07576 15.0334 9.25737C14.9693 9.39366 14.9576 9.4495 14.9557 9.45874C14.9589 9.56981 15.0176 9.67007 15.1089 9.7266C15.1188 9.72978 15.1729 9.74649 15.318 9.75782C15.5167 9.77336 15.8182 9.7739 16.238 9.7739C16.7268 9.77389 17.1369 9.77388 17.4567 9.79838C17.766 9.82206 18.1302 9.87463 18.4355 10.0776C19.0284 10.4716 19.3367 11.1749 19.2285 11.8773C19.1729 12.2386 18.9678 12.5434 18.7773 12.7893C18.5803 13.0435 18.3046 13.3484 17.9756 13.7121L12.384 19.8952C11.8711 20.4625 11.4393 20.94 11.088 21.2463C10.9093 21.402 10.6983 21.5621 10.4628 21.6576C10.2035 21.7629 9.86127 21.8076 9.52137 21.6305C9.18223 21.4538 9.02287 21.1486 8.95948 20.8774C8.90175 20.6304 8.91012 20.3659 8.93375 20.1296C8.98022 19.6648 9.11946 19.035 9.28499 18.2864L9.98325 15.1277C10.1218 14.5012 10.2063 14.1103 10.2279 13.8242C10.2576 13.5884 10.0519 13.4872 9.94529 13.4662C9.66378 13.4254 9.26688 13.4236 8.62804 13.4236L8.11198 13.4236C7.41908 13.4236 6.81593 13.4237 6.34985 13.3543C5.85677 13.2808 5.32891 13.1044 4.99741 12.5916C4.66669 12.0801 4.72072 11.5262 4.85366 11.0454C4.97963 10.5899 5.22437 10.0364 5.50605 9.39944L7.35631 5.21448L7.35631 5.21448C7.61688 4.62508 7.83598 4.12946 8.05945 3.74142C8.29628 3.33017 8.56991 2.98046 8.96967 2.71931C9.3697 2.45798 9.79951 2.34835 10.2706 2.2977C10.7146 2.24997 11.2546 2.24998 11.8958 2.25L14.0836 2.25C14.8522 2.24995 15.5133 2.24991 16.0173 2.32514Z\" fill=\"currentColor\" opacity=\"0.4\"></path></svg>",
    image: "images/PCM Service 2.webp",
    description:
      "From reception desks to luxury décor, we carefully move and reinstall your public space furnishings to match your hotel's style."
  },
  {
    title: "Kitchen and Hospitality Equipment Moves",
       icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7.94845 2.44345C9.07948 1.82495 10.3867 1.25 11.9985 1.25C13.6104 1.25 14.9181 1.82495 16.0497 2.44344C16.3947 2.63198 16.7138 2.81769 17.0178 2.99462L17.0178 2.99465C17.7572 3.42491 18.4073 3.80327 19.123 4.04418C19.5452 4.18628 19.9241 4.31383 20.1922 4.4247C20.4461 4.52967 20.7515 4.67524 20.9669 4.92789C21.1572 5.15108 21.2534 5.39922 21.317 5.63441C21.3752 5.84978 21.425 6.14115 21.4733 6.4238C22.6415 13.2606 20.0994 19.7705 13.809 22.3128C13.1957 22.5608 12.7277 22.75 12.0016 22.75C11.2755 22.75 10.8076 22.5608 10.1942 22.3128C3.90365 19.7706 1.35899 13.2609 2.52688 6.42385C2.57513 6.14122 2.62487 5.84993 2.6831 5.63457C2.74669 5.3994 2.84288 5.15129 3.03312 4.92811C3.24849 4.67545 3.55387 4.52984 3.80771 4.42484C4.07585 4.31393 4.45481 4.18631 4.87699 4.04413C5.59226 3.80324 6.24184 3.42498 6.98063 2.99479C7.28455 2.81782 7.60356 2.63206 7.94845 2.44345Z\" fill=\"currentColor\" opacity=\"0.4\"></path><path d=\"M16.751 9.25V13.75C16.751 14.3196 16.357 14.6614 16.0782 14.8521C15.8019 15.0411 15.4142 15.2311 14.9936 15.4371L12.8055 16.5097C12.6106 16.6069 12.3237 16.75 12.001 16.75C11.6783 16.75 11.3914 16.6069 11.1964 16.5097L9.00836 15.4371C8.58773 15.231 8.20003 15.0411 7.92372 14.8521C7.64494 14.6614 7.25098 14.3196 7.25098 13.75V9.25C7.25098 8.6804 7.64494 8.33859 7.92372 8.14789C8.20002 7.95888 8.58772 7.76896 9.00835 7.5629L11.1964 6.49031C11.3914 6.39307 11.6783 6.25 12.001 6.25C12.3237 6.25 12.6106 6.39308 12.8055 6.49031L14.9936 7.56292C15.4143 7.76897 15.8019 7.95888 16.0782 8.14789C16.357 8.33859 16.751 8.6804 16.751 9.25ZM12.751 12.0368L15.251 10.8105V13.6004L12.751 14.8657V12.0368ZM8.75098 13.6005L11.251 14.8657V12.0368L8.75098 10.8105V13.6005Z\" fill=\"currentColor\" fill-rule=\"evenodd\"></path></svg>",
    image: "images/PCM Service 3.webp",
    description:
      "Specialised handling for kitchen equipment like ovens, dishwashers, and refrigeration units using protective packing and tools."
  },
  {
    title: "Office and Admin Equipment Relocation",
       icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M17.7502 10.7498C18.3025 10.7498 18.7502 11.1975 18.7502 11.7498V12.0043C19.8691 12.3317 20.7816 13.1983 20.9965 14.3755C21.0957 14.9188 20.7357 15.4397 20.1924 15.5389C19.6491 15.6381 19.1283 15.2781 19.029 14.7348C18.9548 14.3281 18.4928 13.8611 17.7502 13.8611C16.9128 13.8611 16.4586 14.4325 16.4586 14.8775C16.4586 15.2436 16.5529 15.3373 16.6057 15.3798C16.7083 15.4622 17.0055 15.6059 17.7502 15.6059C18.6619 15.6059 19.5598 15.7563 20.2392 16.2847C20.9747 16.8568 21.2502 17.7035 21.2502 18.6224C21.2502 19.6399 20.8347 20.4577 20.1003 20.9837C19.6957 21.2736 19.2301 21.4497 18.7502 21.5453V21.7498C18.7502 22.302 18.3025 22.7498 17.7502 22.7498C17.198 22.7498 16.7502 22.302 16.7502 21.7498V21.5099C15.4027 21.1598 14.2502 20.1164 14.2502 18.6224C14.2502 18.0701 14.698 17.6224 15.2502 17.6224C15.8025 17.6224 16.2502 18.0701 16.2502 18.6224C16.2502 18.9938 16.7104 19.6389 17.7502 19.6389C18.3241 19.6389 18.7153 19.5157 18.9357 19.3578C19.1062 19.2357 19.2502 19.0452 19.2502 18.6224C19.2502 18.1009 19.1091 17.9395 19.0113 17.8634C18.8574 17.7437 18.5052 17.6059 17.7502 17.6059C16.8283 17.6059 15.9797 17.4423 15.3531 16.939C14.6768 16.3956 14.4586 15.6252 14.4586 14.8775C14.4586 13.4544 15.4773 12.3807 16.7502 12.0058V11.7498C16.7502 11.1975 17.198 10.7498 17.7502 10.7498Z\" fill=\"currentColor\" fill-rule=\"evenodd\"></path><path d=\"M11.1842 22.7498C9.5903 22.7498 8.33513 22.7498 7.33936 22.646C6.32263 22.5401 5.48656 22.319 4.77134 21.8151C4.38955 21.5461 4.04906 21.226 3.76097 20.8638C3.21609 20.1787 2.97573 19.3732 2.86135 18.401C2.75022 17.4566 2.75023 16.2691 2.75024 14.7752V12.1541C2.75024 10.6957 2.75024 9.56414 2.81049 8.65078C2.87155 7.72497 2.99679 6.97154 3.27194 6.27724C4.11005 4.16235 5.87488 2.51115 8.09019 1.73349C9.46906 1.24945 11.161 1.24957 14.1264 1.24979L14.4891 1.24978C16.1242 1.24944 17.1432 1.24923 17.9839 1.54434C19.333 2.01792 20.4145 3.02603 20.9295 4.32563C21.1042 4.76637 21.1792 5.23427 21.2151 5.7792C21.2503 6.31174 21.2502 6.96737 21.2502 7.79163V8.99881C21.2502 9.55162 20.8021 9.99976 20.2493 9.99976C19.6972 9.99976 19.2493 9.55271 19.2484 9.0006L19.2466 7.99976C19.2277 5.98349 19.1099 4.86689 18.3715 4.12848C17.4928 3.2498 16.0786 3.2498 13.2501 3.2498H12.9558C12.4511 3.2498 12.1988 3.2498 11.8594 3.43795C11.5201 3.6261 11.4492 3.73958 11.3075 3.96654C11.0599 4.36294 10.9168 4.83133 10.9168 5.33313C10.9168 5.48026 10.9233 5.63844 10.9315 5.81604L10.9346 5.88192C10.9419 6.03681 10.9498 6.20539 10.9533 6.3735C10.9612 6.75359 10.9492 7.19713 10.8345 7.62528C10.611 8.45925 9.95959 9.11066 9.12562 9.33412C8.69747 9.44884 8.25393 9.46085 7.87384 9.45295C7.70571 9.44946 7.53711 9.44154 7.3822 9.43426L7.31638 9.43118C7.13879 9.42294 6.98061 9.41647 6.83348 9.41647C6.35241 9.41647 5.90206 9.54796 5.5164 9.77696C5.28149 9.91645 5.16403 9.9862 4.96763 10.3312C4.77124 10.6763 4.77124 10.9341 4.77124 11.4498V14.7498C4.77124 17.5783 4.77124 18.9925 5.64992 19.8712C6.5286 20.7498 7.94281 20.7498 10.7712 20.7498L12.501 20.7498C13.0529 20.7498 13.5002 21.1972 13.5002 21.7491C13.5002 22.3005 13.0536 22.7476 12.5022 22.7483L11.1842 22.7498Z\" fill=\"currentColor\" opacity=\"0.4\"></path><path d=\"M5.32709 12.9467C5.50982 12.5749 5.9593 12.4217 6.33103 12.6044L8.33103 13.5876C8.70276 13.7703 8.85597 14.2198 8.67324 14.5915C8.49051 14.9632 8.04104 15.1164 7.66931 14.9337L5.66931 13.9506C5.29758 13.7679 5.14436 13.3184 5.32709 12.9467Z\" fill=\"currentColor\" fill-rule=\"evenodd\"></path></svg>",
    image: "images/PCM Service 4.webp",
    description:
      "We securely transport desks, filing cabinets, computers, and documents, ensuring smooth back-office continuity."
  },
  {
    title: "Back-of-House and Storage Removals",
       icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6 7.94845C9.07948 7.94845 10.3867 7.3735 11.9985 7.3735C13.6104 7.3735 14.9181 7.94845 16.0497 8.56694C16.3947 8.75548 16.7138 8.94119 17.0178 9.11812L17.0178 9.11815C17.7572 9.54841 18.4073 9.92677 19.123 10.1677C19.5452 10.3098 19.9241 10.4373 20.1922 10.5482C20.4461 10.6532 20.7515 10.7987 20.9669 11.0514C21.1572 11.2746 21.2534 11.5227 21.317 11.7579C21.3752 11.9733 21.425 12.2647 21.4733 12.5473C22.6415 19.3841 20.0994 25.894 13.809 28.4363C13.1957 28.6843 12.7277 28.8735 12.0016 28.8735C11.2755 28.8735 10.8076 28.6843 10.1942 28.4363C3.90365 25.8941 1.35899 19.3844 2.52688 12.5474C2.57513 12.2647 2.62487 11.9734 2.6831 11.7581C2.74669 11.5229 2.84288 11.2748 3.03312 11.0516C3.24849 10.799 3.55387 10.6533 3.80771 10.5483C4.07585 10.4374 4.45481 10.3098 4.87699 10.1676C5.59226 9.92677 6.24184 9.54851 6.98063 9.11832C7.28455 8.94135 7.60356 8.75559 7.94845 8.56698Z\" fill=\"currentColor\" opacity=\"0.4\"></path><path d=\"M16.751 13.3735V17.8735C16.751 18.4431 16.357 18.7849 16.0782 18.9756C15.8019 19.1646 15.4142 19.3546 14.9936 19.5606L12.8055 20.6332C12.6106 20.7304 12.3237 20.8735 12.001 20.8735C11.6783 20.8735 11.3914 20.7304 11.1964 20.6332L9.00836 19.5606C8.58773 19.3545 8.20003 19.1646 7.92372 18.9756C7.64494 18.7849 7.25098 18.4431 7.25098 17.8735V13.3735C7.25098 12.8039 7.64494 12.4621 7.92372 12.2714C8.20002 12.0824 8.58772 11.8925 9.00835 11.6864L11.1964 10.6138C11.3914 10.5166 11.6783 10.3735 12.001 10.3735C12.3237 10.3735 12.6106 10.5166 12.8055 10.6138L14.9936 11.6864C15.4143 11.8925 15.8019 12.0824 16.0782 12.2714C16.357 12.4621 16.751 12.8039 16.751 13.3735ZM12.751 16.1603L15.251 14.934V17.7239L12.751 18.9892V16.1603ZM8.75098 17.724L11.251 18.9892V16.1603L8.75098 14.934V17.724Z\" fill=\"currentColor\" fill-rule=\"evenodd\"></path></svg>",
    image: "images/PCM Service 5.webp",
    description:
      "Efficiently move linen closets, staff lockers, janitorial supplies, and stockroom contents with organisation intact."
  },
  {
    title: "Décor, Art, and Electronics Handling",
        icon: "<svg class=\"!mt-0 h-6 w-6 text-lime-400 md:h-10 md:w-10\" color=\"currentColor\" fill=\"none\" height=\"24\" viewbox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M11.1842 22.7498C9.5903 22.7498 8.33513 22.7498 7.33936 22.646C6.32263 22.5401 5.48656 22.319 4.77134 21.8151C4.38955 21.5461 4.04906 21.226 3.76097 20.8638C3.21609 20.1787 2.97573 19.3732 2.86135 18.401C2.75022 17.4566 2.75023 16.2691 2.75024 14.7752V12.1541C2.75024 10.6957 2.75024 9.56414 2.81049 8.65078C2.87155 7.72497 2.99679 6.97154 3.27194 6.27724C4.11005 4.16235 5.87488 2.51115 8.09019 1.73349C9.46906 1.24945 11.161 1.24957 14.1264 1.24979L14.4891 1.24978C16.1242 1.24944 17.1432 1.24923 17.9839 1.54434C19.333 2.01792 20.4145 3.02603 20.9295 4.32563C21.1042 4.76637 21.1792 5.23427 21.2151 5.7792C21.2503 6.31174 21.2502 6.96737 21.2502 7.79163V8.99881C21.2502 9.55162 20.8021 9.99976 20.2493 9.99976C19.6972 9.99976 19.2493 9.55271 19.2484 9.0006L19.2466 7.99976C19.2277 5.98349 19.1099 4.86689 18.3715 4.12848C17.4928 3.2498 16.0786 3.2498 13.2501 3.2498H12.9558C12.4511 3.2498 12.1988 3.2498 11.8594 3.43795C11.5201 3.6261 11.4492 3.73958 11.3075 3.96654C11.0599 4.36294 10.9168 4.83133 10.9168 5.33313C10.9168 5.48026 10.9233 5.63844 10.9315 5.81604L10.9346 5.88192C10.9419 6.03681 10.9498 6.20539 10.9533 6.3735C10.9612 6.75359 10.9492 7.19713 10.8345 7.62528C10.611 8.45925 9.95959 9.11066 9.12562 9.33412C8.69747 9.44884 8.25393 9.46085 7.87384 9.45295C7.70571 9.44946 7.53711 9.44154 7.3822 9.43426L7.31638 9.43118C7.13879 9.42294 6.98061 9.41647 6.83348 9.41647C6.35241 9.41647 5.90206 9.54796 5.5164 9.77696C5.28149 9.91645 5.16403 9.9862 4.96763 10.3312C4.77124 10.6763 4.77124 10.9341 4.77124 11.4498V14.7498C4.77124 17.5783 4.77124 18.9925 5.64992 19.8712C6.5286 20.7498 7.94281 20.7498 10.7712 20.7498L12.501 20.7498C13.0529 20.7498 13.5002 21.1972 13.5002 21.7491C13.5002 22.3005 13.0536 22.7476 12.5022 22.7483L11.1842 22.7498Z\" fill=\"currentColor\" opacity=\"0.4\"></path><circle cx=\"17\" cy=\"18\" fill=\"currentColor\" r=\"2.5\"></circle><circle cx=\"7\" cy=\"18\" fill=\"currentColor\" r=\"2.5\"></circle></svg>",
    image: "images/PCM Service 6.webp",
    description:
      "Professional relocation of fragile items like artwork, AV systems, lighting, and mirrors with secure packaging and care."
  }
];
const container = document.getElementById("services");

services.forEach((service, index) => {
  const isFirst = index === 0;
  const card = document.createElement("div");
  card.className =
    "relative service-card group border rounded-lg p-5 shadow-sm transition duration-200 bg-white hover:border-blue-500 hover:shadow-lg";
  card.innerHTML = `
    <div class="flex items-center gap-3">
      <div class="text-lime-500 text-xl">${service.icon}</div>
      <h3 class="font-semibold text-lg">${service.title}</h3>
    </div>

    <div class="absolute left-5 right-5 top-full mt-2 bg-white border border-gray-200 rounded-md p-3 shadow-md text-gray-600 text-sm opacity-0 pointer-events-none group-hover:opacity-100 group-hover:pointer-events-auto transition duration-200 z-10">
      ${service.description}
    </div>

  `;

  container.appendChild(card);
});